;;; -*- Package: ERRNO -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;;
(ext:file-comment
  "$Header: src/code/errno.lisp $")
;;;
;;; **********************************************************************
;;;
;;; This file contains the UNIX low-level support, just enough to run
;;; CMUCL.
;;;
(in-package "ERRNO")
(intl:textdomain "cmucl-unix")

;;;; Errno stuff.

(eval-when (compile eval)

(defparameter *compiler-unix-errors* nil)

(defmacro def-unix-error (name number)
  `(progn
     (defconstant ,name ,number)
     (export ',name)))

) ;eval-when

;;; 
;;; From <errno.h>
;;; 
(def-unix-error ESUCCESS 0)

(def-unix-error EPERM 1)
(def-unix-error ENOENT 2)
(def-unix-error ESRCH 3)
(def-unix-error EINTR 4)
(def-unix-error EIO 5)
(def-unix-error ENXIO 6)
(def-unix-error E2BIG 7)
(def-unix-error ENOEXEC 8)
(def-unix-error EBADF 9)
(def-unix-error ECHILD 10)
(def-unix-error EAGAIN 11)
(def-unix-error ENOMEM 12)
(def-unix-error EACCES 13)
(def-unix-error EFAULT 14)
(def-unix-error ENOTBLK 15)
(def-unix-error EBUSY 16)
(def-unix-error EEXIST 17)
(def-unix-error EXDEV 18)
(def-unix-error ENODEV 19)
(def-unix-error ENOTDIR 20)
(def-unix-error EISDIR 21)
(def-unix-error EINVAL 22)
(def-unix-error ENFILE 23)
(def-unix-error EMFILE 24)
(def-unix-error ENOTTY 25)
(def-unix-error ETXTBSY 26)
(def-unix-error EFBIG 27)
(def-unix-error ENOSPC 28)
(def-unix-error ESPIPE 29)
(def-unix-error EROFS 30)
(def-unix-error EMLINK 31)
(def-unix-error EPIPE 32)
(def-unix-error EDOM 33)
(def-unix-error ERANGE 34)
(def-unix-error EDEADLK 35)
(def-unix-error ENAMETOOLONG 36)
(def-unix-error ENOLCK 37)
(def-unix-error ENOSYS 38)
(def-unix-error ENOTEMPTY 39)
(def-unix-error ELOOP 40)
(def-unix-error EWOULDBLOCK EAGAIN)
(def-unix-error ENOMSG 42)
(def-unix-error EIDRM 43)
(def-unix-error ECHRNG 44)
(def-unix-error EL2NSYNC 45)
(def-unix-error EL3HLT 46)
(def-unix-error EL3RST 47)
(def-unix-error ELNRNG 48)
(def-unix-error EUNATCH 49)
(def-unix-error ENOCSI 50)
(def-unix-error EL2HLT 51)
(def-unix-error EBADE 52)
(def-unix-error EBADR 53)
(def-unix-error EXFULL 54)
(def-unix-error ENOANO 55)
(def-unix-error EBADRQC 56)
(def-unix-error EBADSLT 57)
(def-unix-error EDEADLOCK EDEADLK)
(def-unix-error EBFONT 59)
(def-unix-error ENOSTR 60)
(def-unix-error ENODATA 61)
(def-unix-error ETIME 62)
(def-unix-error ENOSR 63)
(def-unix-error ENONET 64)
(def-unix-error ENOPKG 65)
(def-unix-error EREMOTE 66)
(def-unix-error ENOLINK 67)
(def-unix-error EADV 68)
(def-unix-error ESRMNT 69)
(def-unix-error ECOMM 70)
(def-unix-error EPROTO 71)
(def-unix-error EMULTIHOP 72)
(def-unix-error EDOTDOT 73)
(def-unix-error EBADMSG 74)
(def-unix-error EOVERFLOW 75)
(def-unix-error ENOTUNIQ 76)
(def-unix-error EBADFD 77)
(def-unix-error EREMCHG 78)
(def-unix-error ELIBACC 79)
(def-unix-error ELIBBAD 80)
(def-unix-error ELIBSCN 81)
(def-unix-error ELIBMAX 82)
(def-unix-error ELIBEXEC 83)
(def-unix-error EILSEQ 84)
(def-unix-error ERESTART 85)
(def-unix-error ESTRPIPE 86)
(def-unix-error EUSERS 87)
(def-unix-error ENOTSOCK 88)
(def-unix-error EDESTADDRREQ 89)
(def-unix-error EMSGSIZE 90)
(def-unix-error EPROTOTYPE 91)
(def-unix-error ENOPROTOOPT 92)
(def-unix-error EPROTONOSUPPORT 93)
(def-unix-error ESOCKTNOSUPPORT 94)
(def-unix-error EOPNOTSUPP 95)
(def-unix-error EPFNOSUPPORT 96)
(def-unix-error EAFNOSUPPORT 97)
(def-unix-error EADDRINUSE 98)
(def-unix-error EADDRNOTAVAIL 99)
(def-unix-error ENETDOWN 100)
(def-unix-error ENETUNREACH 101)
(def-unix-error ENETRESET 102)
(def-unix-error ECONNABORTED 103)
(def-unix-error ECONNRESET 104)
(def-unix-error ENOBUFS 105)
(def-unix-error EISCONN 106)
(def-unix-error ENOTCONN 107)
(def-unix-error ESHUTDOWN 108)
(def-unix-error ETOOMANYREFS 109)
(def-unix-error ETIMEDOUT 110)
(def-unix-error ECONNREFUSED 111)
(def-unix-error EHOSTDOWN 112)
(def-unix-error EHOSTUNREACH 113)
(def-unix-error EALREADY 114)
(def-unix-error EINPROGRESS 115)
(def-unix-error ESTALE 116)
(def-unix-error EUCLEAN 117)
(def-unix-error ENOTNAM 118)
(def-unix-error ENAVAIL 119)
(def-unix-error EISNAM 120)
(def-unix-error EREMOTEIO 121)
(def-unix-error EDQUOT 122)
(def-unix-error ENOMEDIUM 123)
(def-unix-error EMEDIUMTYPE 124)
(def-unix-error ECANCELED 125)
(def-unix-error ENOKEY 126)
(def-unix-error EKEYEXPIRED 127)
(def-unix-error EKEYREVOKED 128)
(def-unix-error EKEYREJECTED 129)
(def-unix-error EOWNERDEAD 130)
(def-unix-error ENOTRECOVERABLE 131)
(def-unix-error ERFKILL 132)
(def-unix-error EHWPOISON 133)
